<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * Silent skin for the WordPress Updater class.
 * Overrides the output functions so that no
 * text is printed to the screen during plugin installation.
 */
final class Genesis_Silent_Upgrader_Skin extends WP_Upgrader_Skin {

	/**
	 * Overrides the parent method to prevent screen output.
	 *
	 * @param string $string Not used.
	 * @param mixed  ...$args Optional text replacements.
	 *
	 * @return bool
	 */
	public function feedback( $string, ...$args ) {
		return false;
	}

	/**
	 * Overrides the parent method to prevent screen output.
	 *
	 * @return bool
	 */
	public function header() {
		return false;
	}

	/**
	 * Overrides the parent method to prevent screen output.
	 *
	 * @return bool
	 */
	public function footer() {
		return false;
	}
}
