<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Upgrade;

/**
 * Upgrade class. Called when `db_version` Genesis setting is below 3100.
 *
 * @since 3.1.0
 */
class Upgrade_DB_3100 implements Upgrade_DB_Interface {
	/**
	 * The Genesis Simple Edits option key constant value.
	 *
	 * @var string $gse_settings_field
	 *
	 * @since 3.2.0
	 */
	public $gse_settings_field;

	/**
	 * Constructor.
	 *
	 * @since 3.2.0
	 */
	public function __construct() {
		$this->gse_settings_field = defined( 'GSE_SETTINGS_FIELD' ) ? GSE_SETTINGS_FIELD : null;
	}

	/**
	 * Upgrade method.
	 *
	 * @since 3.1.0
	 */
	public function upgrade() {
		$this->create_footer_setting();
		$this->unset_noodp_noydir();
	}

	/**
	 * Create the footer setting with proper default.
	 *
	 * @since 3.1.0
	 */
	public function create_footer_setting() {
		$footer_text_default   = sprintf( '[footer_copyright before="%s "] · [footer_childtheme_link before="" after=" %s"] [footer_genesis_link url="https://www.studiopress.com/" before=""] · [footer_wordpress_link] · [footer_loginout]', __( 'Copyright', 'genesis' ), __( 'on', 'genesis' ) );
		$old_footer_creds_text = is_null( $this->gse_settings_field ) ? apply_filters( 'genesis_footer_creds_text', null ) : genesis_get_option( 'footer_creds_text', $this->gse_settings_field );

		genesis_update_settings(
			[
				'footer_text' => $old_footer_creds_text ?: $footer_text_default,
			]
		);
	}

	/**
	 * Unset `noodp` and `noydir` SEO settings. They were removed.
	 *
	 * @since 3.1.0
	 */
	public function unset_noodp_noydir() {
		// `noodp` and `noydir` settings were removed: https://github.com/studiopress/genesis/issues/2347
		genesis_update_settings(
			[
				'noodp'  => 'unset',
				'noydir' => 'unset',
			],
			GENESIS_SEO_SETTINGS_FIELD
		);
	}
}
