<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Upgrade;

/**
 * Upgrade class. Called when `db_version` Genesis setting is below 3000.
 *
 * @since 3.1.0
 */
class Upgrade_DB_3000 implements Upgrade_DB_Interface {
	/**
	 * Upgrade method.
	 *
	 * @since 2.7.0
	 * @since 3.1.0 Moved to class method.
	 */
	public function upgrade() {
		if ( genesis_get_option( 'adsense_id' ) ) {
			$header_scripts = genesis_get_option( 'header_scripts' );
			$adsense_id     = genesis_get_option( 'adsense_id' );

			// phpcs:disable -- Script is added to header scripts directly. No enqueue required.
			$adsense = <<<ADSENSE
<script async src="http://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<script>
(adsbygoogle = window.adsbygoogle || []).push({
google_ad_client: "$adsense_id",
enable_page_level_ads: true,
tag_partner: "genesis"
});
</script>
ADSENSE;
			// phpcs:enable

			genesis_update_settings(
				[
					'header_scripts' => $header_scripts . "\n" . $adsense,
				]
			);
		}
	}
}
