---
title: Genesis AMP Support
menuTitle: AMP Support
layout: layouts/base.njk
permalink: developer-features/amp/index.html
minVersion: Genesis 3.0.0+
tags: docs
---

AMP is a technology created by Google to optimize a site for fast, nearly instant loading, and smooth-loading web pages across all devices. With Genesis 3.0 comes AMP specific tools to detect if the AMP plugin for WordPress is active on a site, and if so, output AMP compatible code.

To enable AMP, there are only 4 steps:

1. Install and activate the [AMP Plugin for WordPress](https://wordpress.org/plugins/amp/).
2. Be sure your site is set up to use `https://`, as that is required.
3. Allow the AMP plugin to serve either [Native or Transitional AMP content](https://amp-wp.org/documentation/how-the-plugin-works/amp-plugin-serving-strategies/).
4. Use the [AMP Plugin Compatibility Tool](https://amp-wp.org/documentation/developing-wordpress-amp-sites/how-to-develop-with-the-amp-plugin/) to discover any URLs that are not AMP compatible.

*Note:* If in Native AMP mode, the AMP plugin automatically discards or fixes problems for you; however, the area on the web page may lose some interactivity.

## AMP Compatible Child Themes

Genesis 3.0 ships with AMP compatibility out of the box, but many of the StudioPress and 3rd party themes are built in a way that is incompatible with AMP.

AMP does not allow the use of JavaScript, and limits CSS to 50KB, output inline. While the AMP plugin takes care of the CSS, we need to make sure that our theme isn't using any JavaScript.

### Responsive navigation menus

Genesis 3.0 ships with a built in responsive menu API that no longer depends on Superfish. It's available for all child themes to use via the `genesis_register_responsive_menus()` function. It provides for:

* Mobile menu
* Menu combiner
* Off-screen menu

In addition, this new menu API provides functionality for both AMP and non-AMP menus. In short, it is the new and improved way to register render menus with the Genesis Framework.

Child themes no longer need to include their own `responsive-menus.js` script or do any of the work to enqueue it. Genesis now includes this script and handles all the work of enqueueing it, if you utilize the new responsive menus API.

### Menu Registration

The registration process uses a new function called `genesis_register_responsive_menus()`.  You pass in a configuration array to tell Genesis what you want.

Here is the default configuration:

```php
[
	'script' => [
		'mainMenu'            => __( 'Menu', 'genesis' ),
		'menuIconClass'       => 'dashicons-before dashicons-menu',
		'menuIconOpenedClass' => 'dashicons-before dashicons-no-alt',
		'subMenu'             => __( 'Submenu', 'genesis' ),
		'subMenuIconClass'    => 'dashicons-before dashicons-arrow-down-alt2',
		'menuClasses'         => [
			'combine' => [],
			'others'  => [],
		],
	],
	'extras' => [
		'media_query_width' => '1023px',
		'css'               => '',
		'enable_AMP'        => true,
		'enable_non_AMP'    => true,
	],
]

```

You only need to pass in the custom parameters, i.e. the ones that are different than the default above.

#### The Code

First, let's register the responsive menu and pass it a config:

```php
if ( function_exists( 'genesis_register_responsive_menus' ) ) {
	genesis_register_responsive_menus( genesis_get_config( 'responsive-menus' ) );
}
```

With this code, we will also need to create a config file located at `%themeroot%/config/responsive-menus.php`. You can view some sample config file code below.

#### Config Examples

Here's an example from the [Genesis Sample](https://github.com/studiopress/genesis-sample/blob/develop/config/responsive-menus.php) child theme:

```php
/**
 * Genesis responsive menus settings. (Requires Genesis 3.0+.)
 */
return [
	'script' => [
		'menuClasses' => [
			'others' => [ '.nav-primary' ],
		],
	],
	'extras' => [
		'media_query_width' => '960px',
	],
];
```

Here's an example config for the Infinity Pro child theme:

```php
return [
	'script' => [
		'menuIconClass'       => 'ionicons-before ion-ios-drag',
		'menuIconOpenedClass' => 'ionicons-before ion-ios-drag',
		'subMenuIconClass'    => 'ionicons-before ion-chevron-down',
		'menuClasses'         => [
			'others' => [ '.nav-primary' ],
		],
	],
	'extras' => [
		'media_query_width' => '800px',
		'css'               => 'nav.genesis-responsive-menu.toggled-on { display: block; }',
	],
]
```

Here's an example config for the Essence Pro child theme:

```php
return [
	'script' => [
		'menuIconClass'       => 'ionicons-before ion-ios-menu',
		'menuIconOpenedClass' => 'ionicons-before ion-ios-menu',
		'subMenuIconClass'    => 'ionicons-before ion-ios-arrow-down',
		'menuClasses'         => [
			'combine' => [
				'.nav-primary',
				'.nav-off-screen',
			],
			'others'  => [],
		],
	],
]
```

### CSS

#### Genesis CSS

Genesis outputs basic CSS for the responsive AMP menu that you can alter or remove with the `genesis_amp_menu_css` filter.

#### Child theme CSS
Your child theme will need additional CSS to style AMP for your theme. See the [AMP specific CSS](https://github.com/studiopress/genesis-sample/blob/develop/lib/amp/amp.css) in the Genesis Sample child theme. It's well documented inline, and can serve as the basis for any of your child theme projects.

Also, some features that were previously achieved with JavaScript can be replaced by CSS and/or AMP components. For instance, you can set column heights to match with [pure CSS using Flexbox](https://css-tricks.com/fluid-width-equal-height-columns/).
