<#
const value = {
	vertical: '',
	horizontal: '',
	...data.value
}
const icons = {
	stretch_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M10 15.6045C9.5957 15.6045 9.28516 15.3057 9.28516 14.8955V5.09277C9.28516 4.69434 9.5957 4.39551 10 4.39551C10.4043 4.39551 10.709 4.69434 10.709 5.09277V14.8955C10.709 15.3057 10.4043 15.6045 10 15.6045ZM8.3418 9.99707C8.3418 10.4307 8.04297 10.7295 7.5918 10.7295H3.93555L2.81641 10.6709L4.52734 12.3467C4.66797 12.4814 4.75586 12.6572 4.75586 12.8682C4.75586 13.2666 4.45703 13.5654 4.03516 13.5654C3.84766 13.5654 3.66602 13.4893 3.51367 13.3311L0.789062 10.542C0.648438 10.3955 0.554688 10.208 0.554688 9.99707C0.554688 9.78613 0.648438 9.59863 0.789062 9.45801L3.51367 6.66309C3.66602 6.50488 3.84766 6.42285 4.03516 6.42285C4.45703 6.42285 4.75586 6.72168 4.75586 7.12598C4.75586 7.33691 4.66797 7.5127 4.52734 7.64746L2.81641 9.32324L3.93555 9.26465H7.5918C8.04297 9.26465 8.3418 9.56348 8.3418 9.99707ZM11.6523 9.99707C11.6523 9.56348 11.957 9.26465 12.4023 9.26465H16.0645L17.1836 9.32324L15.4668 7.64746C15.3262 7.5127 15.2441 7.33691 15.2441 7.12598C15.2441 6.72168 15.5371 6.42285 15.959 6.42285C16.1465 6.42285 16.334 6.50488 16.4863 6.66309L19.2109 9.45801C19.3516 9.59863 19.4453 9.78613 19.4453 9.99707C19.4453 10.208 19.3516 10.3955 19.2109 10.542L16.4863 13.3311C16.334 13.4893 16.1465 13.5654 15.959 13.5654C15.5371 13.5654 15.2441 13.2666 15.2441 12.8682C15.2441 12.6572 15.3262 12.4814 15.4668 12.3467L17.1836 10.6709L16.0645 10.7295H12.4023C11.957 10.7295 11.6523 10.4307 11.6523 9.99707Z" fill="currentColor"/>
		</svg>
	`,
	start_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M2.74219 17.4805C2.47559 17.4805 2.24316 17.2754 2.24316 17.0088V2.10645C2.24316 1.83984 2.47559 1.63477 2.74219 1.63477C3.01562 1.63477 3.24805 1.83984 3.24805 2.10645V17.0088C3.24805 17.2754 3.01562 17.4805 2.74219 17.4805ZM6.07129 8.90137C5.05957 8.90137 4.50586 8.36133 4.50586 7.36328V4.98438C4.50586 3.98633 5.05957 3.44629 6.07129 3.44629H11.2324C12.251 3.44629 12.7979 3.98633 12.7979 4.98438V7.36328C12.7979 8.36133 12.251 8.90137 11.2324 8.90137H6.07129ZM6.07129 15.6758C5.05957 15.6758 4.50586 15.1357 4.50586 14.1377V11.7588C4.50586 10.7676 5.05957 10.2207 6.07129 10.2207H16.0723C17.0908 10.2207 17.6377 10.7676 17.6377 11.7588V14.1377C17.6377 15.1357 17.0908 15.6758 16.0723 15.6758H6.07129Z" fill="currentColor"/>
		</svg>
	`,
	center_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M4.99951 16.1182C3.98096 16.1182 3.43408 15.5781 3.43408 14.5801V12.2012C3.43408 11.21 3.98096 10.6631 4.99951 10.6631H9.49756V9.34375H7.41943C6.40088 9.34375 5.854 8.80371 5.854 7.80566V5.42676C5.854 4.42871 6.40088 3.88867 7.41943 3.88867H9.49756V2.54883C9.49756 2.28223 9.72998 2.07715 9.99658 2.07715C10.2632 2.07715 10.5024 2.28223 10.5024 2.54883V3.88867H12.5806C13.5923 3.88867 14.146 4.42871 14.146 5.42676V7.80566C14.146 8.80371 13.5923 9.34375 12.5806 9.34375H10.5024V10.6631H15.0005C16.0122 10.6631 16.5659 11.21 16.5659 12.2012V14.5801C16.5659 15.5781 16.0122 16.1182 15.0005 16.1182H10.5024V17.4512C10.5024 17.7178 10.2632 17.9229 9.99658 17.9229C9.72998 17.9229 9.49756 17.7178 9.49756 17.4512V16.1182H4.99951Z" fill="currentColor"/>
		</svg>
	`,
	end_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M17.1982 17.9229C16.9316 17.9229 16.6924 17.7178 16.6924 17.4512V2.54883C16.6924 2.28223 16.9316 2.07715 17.1982 2.07715C17.4648 2.07715 17.6973 2.28223 17.6973 2.54883V17.4512C17.6973 17.7178 17.4648 17.9229 17.1982 17.9229ZM13.8691 9.34375H8.70801C7.68945 9.34375 7.14258 8.80371 7.14258 7.80566V5.42676C7.14258 4.42871 7.68945 3.88867 8.70801 3.88867H13.8691C14.8809 3.88867 15.4346 4.42871 15.4346 5.42676V7.80566C15.4346 8.80371 14.8809 9.34375 13.8691 9.34375ZM13.8691 16.1182H3.86816C2.84961 16.1182 2.30273 15.5781 2.30273 14.5801V12.2012C2.30273 11.21 2.84961 10.6631 3.86816 10.6631H13.8691C14.8809 10.6631 15.4346 11.21 15.4346 12.2012V14.5801C15.4346 15.5781 14.8809 16.1182 13.8691 16.1182Z" fill="currentColor"/>
		</svg>
	`,
	evenly_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<rect y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
			<rect x="2.5" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="8" y="3.96875" width="4" height="12.063" rx="1" fill="currentColor"/>
			<rect x="13.5" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="19" y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
		</svg>
	`,
	around_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<rect y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
			<rect x="2.5" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="8" y="3.96875" width="4" height="12.063" rx="1" fill="currentColor"/>
			<rect x="13.5" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="19" y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
		</svg>
	`,
	between_h: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<rect y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
			<rect x="1" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="8" y="3.96875" width="4" height="12.063" rx="1" fill="currentColor"/>
			<rect x="15" y="5.92773" width="4" height="8.14404" rx="1" fill="currentColor"/>
			<rect x="19" y="2.07715" width="1" height="15.8457" rx="0.5" fill="currentColor"/>
		</svg>
	`,

	/* Vertical */
	stretch_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M10 8.70801C9.56641 8.70801 9.26758 8.40332 9.26758 7.95801V5.63184L9.32031 4.55957L8.00781 5.98926C7.87891 6.1416 7.70898 6.21777 7.49805 6.21777C7.09961 6.21777 6.80664 5.9248 6.80664 5.52051C6.80664 5.32715 6.88867 5.14551 7.04102 4.99316L9.46094 2.63184C9.60156 2.49121 9.78906 2.40332 10 2.40332C10.2109 2.40332 10.3984 2.49121 10.5449 2.63184L12.9648 4.99316C13.1113 5.14551 13.1992 5.32715 13.1992 5.52051C13.1992 5.9248 12.9062 6.21777 12.5078 6.21777C12.291 6.21777 12.127 6.1416 11.9922 5.98926L10.6855 4.55957L10.7324 5.63184V7.95801C10.7324 8.40332 10.4336 8.70801 10 8.70801ZM3.94141 9.99707C3.94141 9.59863 4.24609 9.28809 4.65039 9.28809H15.3555C15.7598 9.28809 16.0586 9.59863 16.0586 9.99707C16.0586 10.4014 15.7598 10.7119 15.3555 10.7119H4.65039C4.24609 10.7119 3.94141 10.4014 3.94141 9.99707ZM10 11.292C10.4336 11.292 10.7324 11.5908 10.7324 12.0361V14.3682L10.6855 15.4346L11.9922 14.0049C12.127 13.8584 12.291 13.7822 12.5078 13.7822C12.9062 13.7822 13.1992 14.0752 13.1992 14.4795C13.1992 14.667 13.1113 14.8545 12.9648 15.001L10.5449 17.3623C10.3984 17.5088 10.2109 17.5967 10 17.5967C9.78906 17.5967 9.60156 17.5088 9.46094 17.3623L7.04102 15.001C6.88867 14.8545 6.80664 14.667 6.80664 14.4795C6.80664 14.0752 7.09961 13.7822 7.49805 13.7822C7.70898 13.7822 7.87891 13.8584 8.00781 14.0049L9.32031 15.4346L9.26758 14.3682V12.0361C9.26758 11.5908 9.56641 11.292 10 11.292Z" fill="currentColor"/>
		</svg>
	`,
	start_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M2.55566 3.29736C2.28223 3.29736 2.07715 3.06494 2.07715 2.79834C2.07715 2.53174 2.28223 2.29248 2.55566 2.29248H17.4512C17.7178 2.29248 17.9229 2.53174 17.9229 2.79834C17.9229 3.06494 17.7178 3.29736 17.4512 3.29736H2.55566ZM5.42676 17.7075C4.42871 17.7075 3.88867 17.1606 3.88867 16.1421V6.14111C3.88867 5.12939 4.42871 4.57568 5.42676 4.57568H7.80566C8.80371 4.57568 9.34375 5.12939 9.34375 6.14111V16.1421C9.34375 17.1606 8.80371 17.7075 7.80566 17.7075H5.42676ZM12.208 12.8677C11.21 12.8677 10.6631 12.3208 10.6631 11.3022V6.14111C10.6631 5.12939 11.21 4.57568 12.208 4.57568H14.5869C15.5781 4.57568 16.125 5.12939 16.125 6.14111V11.3022C16.125 12.3208 15.5781 12.8677 14.5869 12.8677H12.208Z" fill="currentColor"/>
		</svg>
	`,
	center_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M2.55566 10.499C2.28223 10.499 2.07715 10.2598 2.07715 9.99316C2.07715 9.72656 2.28223 9.49414 2.55566 9.49414H3.88867V4.99609C3.88867 3.97754 4.42871 3.43066 5.42676 3.43066H7.80566C8.80371 3.43066 9.34375 3.97754 9.34375 4.99609V9.49414H10.6631V7.41602C10.6631 6.39746 11.21 5.85059 12.208 5.85059H14.5869C15.5781 5.85059 16.125 6.39746 16.125 7.41602V9.49414H17.4512C17.7178 9.49414 17.9229 9.72656 17.9229 9.99316C17.9229 10.2598 17.7178 10.499 17.4512 10.499H16.125V12.5703C16.125 13.5889 15.5781 14.1357 14.5869 14.1357H12.208C11.21 14.1357 10.6631 13.5889 10.6631 12.5703V10.499H9.34375V14.9902C9.34375 16.0088 8.80371 16.5693 7.80566 16.5693H5.42676C4.42871 16.5693 3.88867 16.0088 3.88867 14.9902V10.499H2.55566Z" fill="currentColor"/>
		</svg>

	`,
	end_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M5.42676 15.4243C4.42871 15.4243 3.88867 14.8774 3.88867 13.8589V3.85791C3.88867 2.83936 4.42871 2.29248 5.42676 2.29248H7.80566C8.80371 2.29248 9.34375 2.83936 9.34375 3.85791V13.8589C9.34375 14.8774 8.80371 15.4243 7.80566 15.4243H5.42676ZM12.208 15.4243C11.21 15.4243 10.6631 14.8774 10.6631 13.8589V8.69775C10.6631 7.68604 11.21 7.13232 12.208 7.13232H14.5869C15.5781 7.13232 16.125 7.68604 16.125 8.69775V13.8589C16.125 14.8774 15.5781 15.4243 14.5869 15.4243H12.208ZM2.55566 17.7075C2.28223 17.7075 2.07715 17.4751 2.07715 17.2085C2.07715 16.9419 2.28223 16.7026 2.55566 16.7026H17.4512C17.7178 16.7026 17.9229 16.9419 17.9229 17.2085C17.9229 17.4751 17.7178 17.7075 17.4512 17.7075H2.55566Z" fill="currentColor"/>
		</svg>
	`,
	evenly_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<rect x="17.9229" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 0)" fill="currentColor"/>
			<rect x="14.072" y="2.5" width="4" height="8.14404" rx="1" transform="rotate(90 14.072 2.5)" fill="currentColor"/>
			<rect x="16.0315" y="8" width="4" height="12.063" rx="1" transform="rotate(90 16.0315 8)" fill="currentColor"/>
			<rect x="14.072" y="13.5" width="4" height="8.14404" rx="1" transform="rotate(90 14.072 13.5)" fill="currentColor"/>
			<rect x="17.9229" y="19" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 19)" fill="currentColor"/>
		</svg>
	`,
	around_v: `
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
			<rect x="17.9229" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 0)" fill="currentColor"/>
			<rect x="14.072" y="2.5" width="4" height="8.14404" rx="1" transform="rotate(90 14.072 2.5)" fill="currentColor"/>
			<rect x="16.0315" y="8" width="4" height="12.063" rx="1" transform="rotate(90 16.0315 8)" fill="currentColor"/>
			<rect x="14.072" y="13.5" width="4" height="8.14404" rx="1" transform="rotate(90 14.072 13.5)" fill="currentColor"/>
			<rect x="17.9229" y="19" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 19)" fill="currentColor"/>
		</svg>
	`,
	between_v: `
	<svg width="20" height="20" viewBox="0 0 20 20" fill="none">
		<rect x="17.9229" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 0)" fill="currentColor"/>
		<rect x="14.0723" y="1" width="4" height="8.14404" rx="1" transform="rotate(90 14.0723 1)" fill="currentColor"/>
		<rect x="16.0315" y="8" width="4" height="12.063" rx="1" transform="rotate(90 16.0315 8)" fill="currentColor"/>
		<rect x="14.0723" y="15" width="4" height="8.14404" rx="1" transform="rotate(90 14.0723 15)" fill="currentColor"/>
		<rect x="17.9229" y="19" width="1" height="15.8457" rx="0.5" transform="rotate(90 17.9229 19)" fill="currentColor"/>
	</svg>
	`,
}

const options = {
	stretch:         '<?php _e( 'Stretch', 'fl-builder' ); ?>',
	start:           '<?php _e( 'Start', 'fl-builder' ); ?>',
	center:          '<?php _e( 'Center', 'fl-builder' ); ?>',
	end:             '<?php _e( 'End', 'fl-builder' ); ?>',
	'space-evenly':  '<?php _e( 'Space Evenly', 'fl-builder' ); ?>',
	'space-between': '<?php _e( 'Space Between', 'fl-builder' ); ?>',
	'space-around' : '<?php _e( 'Space Around', 'fl-builder' ); ?>'
}

const vertical = wp.template( 'fl-builder-field-button-group' )( {
	name: data.name + '[vertical]',
	rootName: data.name,
	value: value.vertical,
	field: {
		fill_space: true,
		icons_only: true,
		options,
		tooltip: options,
		icons: {
			stretch:         icons.stretch_v,
			start:           icons.start_v,
			center:          icons.center_v,
			end:             icons.end_v,
			'space-evenly':  icons.evenly_v,
			'space-between': icons.between_v,
			'space-around':  icons.around_v
		}
	},
} );

const horizontal = wp.template( 'fl-builder-field-button-group' )( {
	name: data.name + '[horizontal]',
	rootName: data.name,
	value: value.horizontal,
	field: {
		fill_space: true,
		icons_only: true,
		options,
		tooltip: options,
		icons: {
			stretch:         icons.stretch_h,
			start:           icons.start_h,
			center:          icons.center_h,
			end:             icons.end_h,
			'space-evenly':  icons.evenly_h,
			'space-between': icons.between_h,
			'space-around':  icons.around_h
		}
	}
} )

#>
<div class="fl-button-group-cluster">
{{{ vertical }}}
{{{ horizontal }}}
</div>
